<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/ /** */

require_once 'xml_attachment.php';
require_once APPPATH.'models/das_log_entry.php';
require_once APPPATH.'libraries/xml_document/ccd.php';

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
* @todo - separate patient document methods into a child class
*/
class Patient_document_attachment extends XML_attachment{		

	protected static $patient_document_classes = array('C32_attachment', 'CCDA_attachment', 'CCR_attachment');
	
	//Patient documents
	protected $_das_save_date;
	protected $_description;
	protected $_purpose; //purpose of disclosure
	protected $_ssn;
	protected $_transformed_markup;	
	protected $_xsl_path; //path to the XSL file, relative to APPPATH

	protected $_property_validation_rules= array( 'purpose' => 'nonempty_string');
	
	
	#TODO - REFACTOR USING NEW SYSTEM CACHE METHODS ONCE WE HAVE THE OT11 CODE MERGED IN	
	function download_as_pdf(){
		$CI = get_instance();
				
		$transformed_markup_filename = '__dpii_transformed_'.replace_last_with('.xml', '.html', $this->name);
		$pdf_filename = replace_last_with('.xml', '.pdf', $this->name);
		
		if(!$CI->user->add_attachment_to_cache($transformed_markup_filename, $this->transformed_markup())){
			$this->error->warning('Unable to write transformed markup for '.$this->name.' to cache');
			return $this->download();
		}		
		
		shell_exec('wkhtmltopdf '.'  '.escapeshellarg($CI->user->attachment_cache().$transformed_markup_filename).' '.escapeshellarg($CI->user->attachment_cache().$pdf_filename).' 2>&1');
		$CI->user->remove_attachment_from_cache($transformed_markup_filename); //remove our temporary markup file so that it doesn't accidentally get attached to the message
		
		//download the pdf if we created it successfully
		$pdf = $CI->user->attachment_from_cache($pdf_filename);
		
		if(is_a($pdf, 'Attachment'))
			$pdf->download();
		else{
			$this->error->warning('Unable to generate pdf for '.$this->name);
			$this->download(); //default to a normal download of this fail if our pdf write failed
		}
		
		//remove the pdf so that we won't accidentally attach it to the message - but if we create a system cache, we should comment this out so that we don't have to regenerate each time
		$CI->user->remove_attachment_from_cache($pdf_filename);	
	}	
	
	function save_disclosure(){
		if($this->property_is_empty('message_id')) return $this->error->warning('Cannot save a disclosure for '.$this->name.' without a message id');		
		
		$CI = get_instance();
		$values_to_save = array('mailbox' => $CI->mailbox->name,
								'id' => $this->message_id,
								'ssn' => str_replace('-', '', $this->ssn),
								'purpose' => $this->purpose,
								'hash' => $this->hash);
							
		$CI->api->clear();
		return $CI->api->call('direct/disclosure/log', $values_to_save,'POST');
	}		
	
	function url_for_download_as_pdf(){
		if(Message::formatted_like_an_id($this->message_id))
			return site_url('inbox/message/'.$this->message_id.'/attachments/download/format/pdf/'.rawurlencode($this->name));
		return site_url('inbox/compose/draft/attachments/download/format/pdf/'.rawurlencode($this->name));	
	}
	
	function view(){
		echo $this->transformed_markup();
	}	
	
////////////////////
// GETTERS
////////////////////

	function das_save_date($format = null){
		if(!isset($this->_das_save_date) && $this->schema == 'C32'){
			get_instance()->db->select('id, message_id, saved_date')->order_by('saved_date', 'desc');
			$saved_info = DAS_log_entry::find_one_for_attachment($this);
			if(DAS_log_entry::is_an_entity($saved_info)){ $this->_das_save_date = $saved_info->saved_date; }
		}
		if(!is_null($format) && isset($this->_das_save_date)){ return date($format, $this->_das_save_date);}
		return $this->_das_save_date;
	}
		
	function description(){
		if(!isset($this->_description) && isset($this->binary_string)){
			if(is_object($this->parser)){
				$this->_description = $this->parser->description();
			}
		}
		return $this->_description;
	}		

//////////////////////
// SETTERS
//////////////////////

	function set_ssn($value){
		if(is_numeric($value) && strlen($value) == 9){
			$value = substr($value, 0, 3).'-'.substr($value, 3, 2).'-'.substr($value, 5, 4);
		}
		
		if(!$this->is->string_like_a_social_security_number($value)) return $this->error->property_value_should_be_a_ssn('ssn', $this, $value);	
		$this->_ssn = $value;
	}

	function transformed_markup(){
		if(!isset($this->_transformed_markup)){	
			if($this->property_is_empty('xsl_path') || !file_exists(APPPATH.$this->xsl_path))
				return $this->error->warning("I can't transform the markup for ".$this->describe().' without a valid xsl location, but you gave me '.$this->error->describe($this->xsl_path));
		
				$xml = new DOMDocument; //load xml
				if($xml->loadXml($this->binary_string)){
					$xsl = new DOMDocument; //load xsl
					$xsl->loadXml(file_get_contents(APPPATH.$this->xsl_path));
					$proc = new XSLTProcessor;
					$proc->importStyleSheet($xsl); // attach the xsl rules
					$this->_transformed_markup = $proc->transformToXML($xml);
				}
		}
		return $this->_transformed_markup;
	}		
	
/////////////////////
// STATIC FUNCTIONS
/////////////////////

	public static function create($name, $binary_string, $more_values = array()){
		if(!static::matches_file($name, $binary_string)) return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()).' file', $name);
		
		foreach(static::$patient_document_classes as $patient_document_class){
			require_once $patient_document_class.'.php';
			if($patient_document_class::matches_file($name, $binary_string)){
				return new $patient_document_class(array_merge(compact('name', 'binary_string'), $more_values));
			}
		}
		
		trigger_error($name.' does not match a known patient document class', E_USER_WARNING);
		return new Patient_document_attachment(array_merge(compact('name', 'binary_string'), $more_values));
	}

	public static function matches_file($name, $binary_string){
		if(!parent::matches_file($name, $binary_string)) return false;
		 foreach(static::$patient_document_classes as $patient_document_class){
			require_once $patient_document_class.'.php';
			if($patient_document_class::matches_file($name, $binary_string)){
				return true;
			}
		} 
		return false;	
	}
	
}
?>